%% Sine Wave
% Martin H. Trauth 2 July 2021
%
% We first clear the workspace and the command window. We then close all
% figure windows.
clear, clc, close all
ds = get(0,'ScreenSize');

%%
% We create a sine wave with a period of 20 and an amplitude of 3.
T = 20;
A = 3;
Fs = 10;

data(:,1) = 0 : 1/Fs : 40;
data(:,2) = A*sin(2*pi*data(:,1)/T);

f1 = figure('Position',[50 ds(4)-500 800 300],...
    'Color','w');
axes('Position',[0.1 0.15 0.8 0.7])
line(data(:,1),data(:,2),...
    'LineWidth',1)
xlabel('Age (kyr)')
ylabel('Proxy (unit)')

%%
% We then create a second sine waves with a period of 20 and an amplitude
% of 3, but with a phase shift of 4.
P = 4;

data(:,3) = A*sin(2*pi*data(:,1)/T + 2*pi/(T/P));

f2 = figure('Position',[50 ds(4)-900 800 300],...
    'Color','w');
axes('Position',[0.1 0.15 0.8 0.7])
line(data(:,1),data(:,2),...
    'LineWidth',1,...
    'Color',[0 0.4470 0.7410])
line(data(:,1),data(:,3),...
    'LineWidth',1,...
    'Color',[0.8500 0.3250 0.0980])
xlabel('Age (kyr)')
ylabel('Proxy (unit)')

print(f2,'-dpng','-r300','figure_2_sinewaves.png')
print(f2,'-depsc2','-r300','figure_2_sinewaves.eps')



